CREATE TABLE sys_platform_sql_execute
(
    id                   bigint(20) PRIMARY KEY,
    sql_name             VARCHAR(255) NULL DEFAULT NULL COMMENT '为SQL命令命名，方便前端显示 ', -- 为SQL命令命名，方便前端显示
    query_sql            TEXT         NULL DEFAULT NULL COMMENT '存储SQL命令 ',                -- 存储SQL命令
    datasource_name      VARCHAR(255) NULL DEFAULT NULL COMMENT '数据源的标识或名称 ',         -- 数据源的标识或名称
    execute_sql_result   TEXT         NULL DEFAULT NULL COMMENT 'SQL执行结果 ',
    execute_sql_delay    bigint(20)   NULL DEFAULT NULL COMMENT 'SQL执行时间/毫秒 ',
    `execute_start_time` datetime(6)  NULL DEFAULT NULL COMMENT '开始时间',
    `execute_end_time`   datetime(6)  NULL DEFAULT NULL COMMENT '结束时间',
    `tenant_id`          bigint(20)   NULL DEFAULT NULL COMMENT '所属租户ID ',
    `belong_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '所属组织ID',
    `remark`             varchar(255) NULL DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) NULL DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   NULL DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) NULL DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  NULL DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NULL DEFAULT 0 COMMENT '记录最后更新时间',
    `audit_data_version` int(11)      NULL DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint(20)   NULL DEFAULT NULL COMMENT '数据归属雇员id',
    `tenant_org_id`      bigint(20)   NULL DEFAULT NULL COMMENT '租户组织ID',
    `sec_ou_id`          bigint(20)   NULL DEFAULT NULL COMMENT '数据归属公司id'
);

alter table sys_platform_sql_execute add column sql_code varchar(255) comment 'SQL编码';
alter table sys_platform_sql_execute add column category varchar(255) comment '分类, [udc]cloudt-system:sqlCategory';
alter table sys_platform_sql_execute add column sql_type varchar(255) comment 'SQL类型';
alter table sys_platform_sql_execute add column limit_size integer comment '限制数据量' ;